
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"

using namespace std;

// https://en.wikipedia.org/wiki/Factorization_of_polynomials_over_finite_fields#Square-free_factorization

int main (int argc, char * const argv[])
{
    int     *order, *freq, km;
    int     i, m, numOrders, numTrials;
    double  p;
    mb      pmb;
    
again:
    
    srand(time(NULL));
    
    p = 0;
    while(p<2 || !isItPrime(p, 35))
    {
        cout << "p: ";
        cin >> p;
    }
    
    m = 0;
    while(m<1)
    {
        cout << "m: ";
        cin >> m;
    }
    cin.ignore();
    
    km = pow(p, m) - 1;
    cout << "p^m - 1 = " << km << endl;
    equate(pmb, p);
    cout << "numInverts = " << numInverts(m, pmb) << endl;
    
    numTrials = 0;
    while(numTrials<1)
    {
        cout << "numTrials: ";
        cin >> numTrials;
    }
    
    findMatrixGroupOrders(order, freq, numOrders, numTrials, m, p);
    for(i=0;i<numOrders;++i)
    {
        cout << "order = " << order[i] << "  ";
        cout << "freq = " << freq[i] << endl;
    }
    cout << endl;
    goto again;
    
    return 0;
}
 /*
 clock_t start, end;
 double elapsed;
 
 start = clock();

end = clock();
elapsed = ((double) (end - start)) / CLOCKS_PER_SEC;
 */
